# windowsServer下的SSL证书申请&续签

## 目录

* [相关文件下载](##相关文件下载)
* [前言](##前言)
* [环境](##前言)
* [SSL证书申请](##SSL证书申请)
    * [SSL证书申请方法一](###SSL证书申请方法一 )
    * [(SSL证书申请方法二<推荐>)](###(SSL证书申请方法二<推荐>) )
* [SSL证书续签](##SSL证书续签)
    * [证书续签+自动化(基于方法一) ](###证书续签+自动化(基于方法一) )
    * [证书续签+自动化(基于方法二) ](###证书续签+自动化(基于方法二))
        * [证书续签2](####证书续签2)
        * [续签自动化2](####续签自动化2)
* [意外状况及方法解决](##意外状况及方法解决)
* [附录](##附录)
    * [相关知识](###相关知识)
    * [".ps1"的脚本定时操作](###".ps1"的脚本定时操作)

## 相关文件下载

Certbot:[Certbot.exe](https://github.com/certbot/certbot/releases/download/v2.9.0/certbot-beta-installer-win_amd64_signed.exe)

## 前言

后续的操作都基于环境安装好的情况下进行，如何安装这里久不详细赘述了。这里的Apache环境由PHPstudy自带的，单独下载的Apache相关路径可能有不相同。

## 环境

WindowsServer(2016)

PHPstudy(8.1.1.3)

MySQL(5.7.26)

Apache(2.4.39)

certbot(2.9.0)

## SSL证书申请

### (SSL证书申请方法一)

WIN+R打开cmd，查看certbot是否能正常运行

```cmd
certbot --version
```

![1](.\image\1.png)

证书申请测试(成功申请后去掉--dry-run再次运行)

*注：在没确定好测试成功前不要去掉--dry-run，成功获取证书5次后得等168小时/7天才能再次申请。*

```
certbot certonly --force-renewal --manual --preferred-challenges dns --key-type rsa --email firewormq@qq.com -d www.fireworm.cc -d fireworm.cc --dry-run
```

参数说明：

```
# certbot：这是Let’s Encrypt证书自动颁发工具的命令名。
# certonly：这个参数告诉certbot只获取证书，而不是安装它。通常与自动 renew 参数一起使用，以仅更新证书而不重新安装。
# --force-renewal：这个参数告诉certbot即使证书还没有到期，也应该尝试更新它。
# --manual：这个参数表示使用手动验证方式，通常在自动验证方式不可用时使用，如无法访问ACME挑战所需的服务。
# --preferred-challenges dns：这个参数指定使用DNS挑战来证明你对域名的控制权。在手动验证过程中，你需要在你的DNS记录中添加特定的记录来证明你的身份。
# --key-type rsa：这个参数指定了证书私钥的类型，这里是RSA。RSA是一种广泛使用的非对称加密算法。
# --email firewormq@qq.com：这个参数指定了与域名相关的联系邮箱，用于接收关于证书的通知和更新。
# -d www.fireworm.cc -d fireworm.cc：这两个参数指定了需要申请证书的域名。certbot将为这两个域名生成和安装TLS证书。
# --dry-run：这个参数告诉 Certbot 进行一次试运行，实际上不会提交任何请求到 Let’s Encrypt 的服务器，也不会影响现有的证书。这用于测试配置是否正确，而不实际更改任何东西。
```

申请完后需进行DNS验证，在域名控制商(我这里是阿里云)添加指定的域名解析，类型为TXT。(如下图)

![2](.\image\2.png)
![3](.\image\3.png)
![3](.\image\4.png)

完成后按Enter即可获取SSL证书，并输出存放路径。

手动定位到原文件将证书导入到PHPstudy的https的证书

![3](.\image\5.png)

导入完成后重启Apache服务器证书将会生效(这里导入完成会自动重启Apache)。

注意：也可手动将证书复制到该路径(如果环境不同则需自己上网查询，注意名称需要在Apache的配置文件中设置，最好还是手动导入)

```
# PHPstudy的Apache存放SSL存放证书路径
C:\phpstudy\Extensions\Apache2.4.39\conf\ssl\
# 配置文件路径
C:\phpstudy\Extensions\Apache2.4.39\conf\vhosts\www.fireworm.cc_443.conf
```

### (SSL证书申请方法二<推荐>)
WIN+R打开cmd，查看certbot是否能正常运行

```cmd
certbot --version
```

![1](.\image\1.png)

证书申请测试(成功申请后去掉--dry-run再次运行)

*注：在没确定好测试成功前不要去掉--dry-run，成功获取证书5次后得等168小时/7天才能再次申请。*

```
certbot certonly --force-renewal --webroot -w C:\phpstudy\WWW\firewormX --key-type rsa -d www.fireworm.cc -d fireworm.cc --email firewormq@qq.com --dry-run
```

```
# certbot：这是Let’s Encrypt证书自动颁发工具的命令名。
# certonly：这个参数告诉certbot只获取证书，而不是安装它。通常与自动 renew 参数一起使用，以仅更新证书而不重新安装。
# --force-renewal：这个参数告诉certbot即使证书还没有到期，也应该尝试更新它。
# --webroot：指定使用 webroot 方式来验证域名的所有权。这是 Let’s Encrypt 提供的一种验证方式，需要在你的 web 服务器的根目录下放置一个特定的文件。
# -w C:\phpstudy_XXpro\WWW\firewormX：指定 webroot 的路径。这里是你的网站根目录的路径。
# --key-type rsa：这个参数指定了证书私钥的类型，这里是RSA。RSA是一种广泛使用的非对称加密算法。
# -d www.fireworm.cc -d fireworm.cc：指定要获取证书的域名。这里包括了两个域名：www.fireworm.cc 和 fireworm.cc。
# --email firewormq@qq.com：这个参数指定了与域名相关的联系邮箱，用于接收关于证书的通知和更新。
# --dry-run：这个参数告诉 Certbot 进行一次试运行，实际上不会提交任何请求到 Let’s Encrypt 的服务器，也不会影响现有的证书。这用于测试配置是否正确，而不实际更改任何东西。
```
手动定位到原文件将证书导入到PHPstudy的https的证书

![3](.\image\5.png)

导入完成后重启Apache服务器证书将会生效(这里导入完成会自动重启Apache，也可手动将证书复制到该路径，注意名称需要在Apache的配置文件中设置，最好还是手动点击导入，方便后续做SSL证书续签自动化)。

注意：如果环境不是PHPstudy下的Apache则需自己上网查询SSL存放路径，以及配置文件。
```
# PHPstudy的Apache存放SSL存放证书路径
C:\phpstudy\Extensions\Apache2.4.39\conf\ssl\
# 配置文件路径
C:\phpstudy\Extensions\Apache2.4.39\conf\vhosts\www.fireworm.cc_443.conf
# 配置文件内容
<VirtualHost *:443>
    DocumentRoot "C:/phpstudy/WWW/Fireworm"
    ServerName www.fireworm.cc
    ServerAlias 
    SSLEngine on
    SSLCertificateFile "C:/phpstudy/Extensions/Apache2.4.39/conf/ssl/www.fireworm.cc.crt"
    SSLCertificateKeyFile "C:/phpstudy/Extensions/Apache2.4.39/conf/ssl/www.fireworm.cc.key"
    SSLCertificateChainFile "C:/phpstudy/Extensions/Apache2.4.39/conf/ssl/www.fireworm.ccchain.crt"
    FcgidInitialEnv PHPRC "C:/phpstudy/Extensions/php/php7.4.3nts"
    AddHandler fcgid-script .php
    FcgidWrapper "C:/phpstudy/Extensions/php/php7.4.3nts/php-cgi.exe" .php
  <Directory "C:/phpstudy/WWW/Fireworm">
      Options FollowSymLinks ExecCGI
      AllowOverride All
      Order allow,deny
      Allow from all
      Require all granted
    DirectoryIndex index.php index.html error/index.html
  </Directory>
  ErrorDocument 400 /error/400.html
  ErrorDocument 403 /error/403.html
  ErrorDocument 404 /error/404.html
  ErrorDocument 500 /error/500.html
  ErrorDocument 501 /error/501.html
  ErrorDocument 502 /error/502.html
  ErrorDocument 503 /error/503.html
  ErrorDocument 504 /error/504.html
  ErrorDocument 505 /error/505.html
  ErrorDocument 506 /error/506.html
  ErrorDocument 507 /error/507.html
  ErrorDocument 510 /error/510.html
</VirtualHost>
```
## SSL证书续签

###  证书续签+自动化(基于方法一)

重复上边申请证书的步骤即可。

关于自动化的安全问题，怕泄漏云厂商的AccessKey出问题，所以没研究了，有兴趣的师傅可以自己研究网上有相关资源。

### 证书续签+自动化(基于方法二)

#### 证书续签2
*注：在没确定好测试成功前不要去掉--dry-run，成功获取证书5次后得等168小时/7天才能再次申请。*

```
# 续签证书
certbot renew --force-renewal --dry-run
```
```
# renew：更新证书
# --force-renewal：这个参数告诉certbot即使证书还没有到期，也应该尝试更新它。
# --dry-run：这个参数告诉 Certbot 进行一次试运行，实际上不会提交任何请求到 Let’s Encrypt 的服务器，也不会影响现有的证书。这用于测试配置是否正确，而不实际更改任何东西。
```
#### 续签自动化2

这里献上powershell脚本，通过定时脚本的方式进行自动化续签。

```
# 续签SSL证书(正式启用请去掉"--dry-run",请注意：一周只能申请正式5次)
certbot renew --force-renewal --dry-run

# 指定.symlink快捷方式文件的路径
$lnkPath_privkeyPem = "C:\Certbot\live\www.fireworm.cc\privkey.pem"
$lnkPath_certPem = "C:\Certbot\live\www.fireworm.cc\cert.pem"
$lnkPath_chainPem = "C:\Certbot\live\www.fireworm.cc\chain.pem"

# 声明复制目标文件路径
$targetPath_privkeyPem = "C:\phpstudy\Extensions\Apache2.4.39\conf\ssl\www.fireworm.cc.key"
$targetPath_certPem = "C:\phpstudy\Extensions\Apache2.4.39\conf\ssl\www.fireworm.cc.crt"
$targetPath_chainPem = "C:\phpstudy\Extensions\Apache2.4.39\conf\ssl\www.fireworm.ccchain.crt"

# 定义一个包含快捷方式文件路径的数组
$symlinkPaths = @(
    $lnkPath_privkeyPem,
    $lnkPath_certPem,
    $lnkPath_chainPem
)

# 定义一个包含对应目标文件路径的数组
$targetPaths = @(
    $targetPath_privkeyPem,
    $targetPath_certPem,
    $targetPath_chainPem
)

# 遍历快捷方式文件路径数组
for ($i = 0;$i -lt $symlinkPaths.Length;$i++) {
    $symlinkPath = $symlinkPaths[$i]
    $symlinkPaths[$i]
    $targetPath =$targetPaths[$i]

    # 检查目标文件是否存在，并打印其内容
    if ([System.IO.File]::Exists($symlinkPath)) {
        # 读取.symlink文件并打印其内容,测试是否输出正常
        # if (Test-Path -PathType Leaf $symlinkPath) {  
        #     # 如果 $symlinkPath 是一个文件  
        #     Write-Host "目标路径是: $symlinkPath"  
        #     Get-Content $symlinkPath | Write-Host  
        # } else {  
        #     Write-Host "$symlinkPath 不是一个文件。"  
        # }
        # 复制文件到指定位置
        try {
            Copy-Item -Path $symlinkPath -Destination $targetPath
            Write-Host "文件 '$symlinkPath' 已成功复制到:$targetPath"
        }
        catch {
            Write-Error "复制文件 '$symlinkPath' 到 '$targetPath' 时发生错误: $_"
        }
    }
    else {
        Write-Error "目标文件不存在: $symlinkPath"
    }
}
#重启Apache服务器
net stop Apache
net start Apache


# 暂停，去掉下面的注释
# Read-Host "按任意键继续..."
```

创建Renew_SSL.ps1脚本后，将其添加到Windows定时任务里面去
```
# 打开运行窗口
win+R
# 输入命令进入计算机管理添加任务定时
compmgmt.msc
```
## 意外状况及方法解决

环境问题

我仔细核查了下，如果是安装的phpsutdy最新版的PHPstudy(8.1.1.3)，这个版本的web服务启动是以无服务的方式启动的，没有切换以服务启动的模式，在之前的版本里面是有的。这里以Apache为例，它是通过Apache下的ApacheMonitor.exe开启的无服务，也就是说在服务列表中"Services.msc"找不到Apache这个服务项，需要自己手动创建注册服务。

*注:服务列表的Apache和phpstudy的无服务Apache只能开启一个。*

WIN+R输入cmd打开命令提示符。(如果注册不了就以管理员的方式启动)

```
# 切换到Apache的bin目录下
cd d:/phpstudy_pro/extensions/Apache2.4.39/bin
# ApacheHTTPServer服务
.\httpd.exe -k install
# 注册服务并指定名称(-n 指定服务显示名称)
.\httpd.exe -k -n Apache
```

相关命令

```
# 删除服务,在命令提示符下
sc delete 服务名称
```

## 附录

### 相关知识

certbot的Windows版本2024-02-09后不在更新，详情请见

[Certbot Discontinuing Windows Beta Support in 2024 - Client dev - Let's Encrypt Community Support (letsencrypt.org)](https://community.letsencrypt.org/t/certbot-discontinuing-windows-beta-support-in-2024/208101)

Certbot的Windows版本最新版本下载链接：

[https://github.com/certbot/certbot/releases/download/v2.9.0/certbot-beta-installer-win_amd64_signed.exe](https://github.com/certbot/certbot/releases/download/v2.9.0/certbot-beta-installer-win_amd64_signed.exe)

```
# 创建 .symlink文件（软链接）
mklink  <链接名称> <目标文件>
mklink "C:\Certbot\live\www.fireworm.cc\cert.pem" "C:\Certbot\archive\www.fireworm.cc\cert3.pem"
```

.symlink相关文章

[符号链接、硬链接及其在 Windows 上的应用举例 - 少数派 (sspai.com)](https://sspai.com/post/66834)

### ".ps1"的脚本定时操作

- 在“程序/脚本”框中，输入 `powershell.exe` 的路径，通常是
```
C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe
```
- 在“添加参数（可选）”框中，输入 

```
-ExecutionPolicy Bypass -File "C:\Path\To\YourScript.ps1
```

- 确保将 `C:\Path\To\YourScript.ps1` 替换为你的 `.ps1` 文件的实际路径。

------

*<u>注：本文章和工具(工具为网络资源非本人开发)仅供学习和研究使用,请勿使用项目的技术手段用于非法用途,任何人造成的任何负面影响,与本人无关.</u>*

<u>[文章来源：https://fireworm.cc](https://fireworm.cc)</u>